/*----------------------------------------


	asmlib wrapper for C


	see asmlib.asm for implementation


	(c) by Holger Picker 2004

	To be released with EMU][.
	Use at your own risk.

	Unfortunately I cannot release the
	full source file for the assembly library yet
	as I'd like to. So this has to do for now... :-(


----------------------------------------*/


/* functions defined in the assembler library */

/*
   please note the class hierachy:

   channel <== image <== window

   IOW: Every window is an image, and every image is a channel.
   Therefore, it is possible to call stringwrite using an image as
   a channel reference pointer, and it is also possible to call
   imagedrawline using a window as an image reference pointer.
*/


#ifndef DEF_INC_ASMLIB_H
#define DEF_INC_ASMLIB_H


// **** public global variables ****

extern unsigned char exitprogram;
extern unsigned int  dvalue1;
extern unsigned int  dvalue2;
extern unsigned int  dvalue3;
extern unsigned int  dvalue4;
extern unsigned int  dvalue5;
extern unsigned int  dvalue6;
extern unsigned int  dvalue7;
extern unsigned int  dvalue8;
extern unsigned char dvalueshow;


// **** public global functions ****

// special assembly library functions
unsigned char		*asmopen();			// call this at the begin of the program
unsigned char		*asmclose();			// call this at the end of the program
void			asmtaskswitch();		// switch between several internal tasks for display handling
void			asmseterror(unsigned char *stringptr);		// set internal error
unsigned char		*asmgeterror();					// get internal error
unsigned char		*asmsetlanguage(unsigned char language);	// set language for messages


// tools
void			debugger	(void *rampointer, unsigned int numbbytes);
void			ramdebugger	(void *rampointer, unsigned int numbbytes);
unsigned char		*assembler	(void *rampointer, unsigned int numbbytes, unsigned char *filename);


// library keyboard
unsigned char		*keyboardsetlayout(unsigned int layoutnumber);
unsigned int		keyboardgetlayout();
int			keyboardjoyx();
int			keyboardjoyy();
unsigned int		keyboardjoyb();
extern unsigned char	keyboardkeymap[256];


// index into keyboardkeymap, NOT ascii code ...
#define KEYBOARDKEYLSHIFT	0x80
#define KEYBOARDKEYRSHIFT	0x81
#define KEYBOARDKEYLCTRL	0x82
#define KEYBOARDKEYRCTRL	0x83
#define KEYBOARDKEYLALT		0x84
#define KEYBOARDKEYRALT		0x85
#define KEYBOARDKEYCAPS		0x86

#define KEYBOARDKEYCLEFT	0x90
#define KEYBOARDKEYCRIGHT	0x91
#define KEYBOARDKEYCUP		0x92
#define KEYBOARDKEYCDOWN	0x93
#define KEYBOARDKEYPUP		0x94
#define KEYBOARDKEYPDOWN	0x95
#define KEYBOARDKEYHOME		0x96
#define KEYBOARDKEYDEL		0x97
#define KEYBOARDKEYEND		0x98
#define KEYBOARDKEYINS		0x99

#define KEYBOARDKEYF1		0xc1
#define KEYBOARDKEYF2		0xc2
#define KEYBOARDKEYF3		0xc3
#define KEYBOARDKEYF4		0xc4
#define KEYBOARDKEYF5		0xc5
#define KEYBOARDKEYF6		0xc6
#define KEYBOARDKEYF7		0xc7
#define KEYBOARDKEYF8		0xc8
#define KEYBOARDKEYF9		0xc9
#define KEYBOARDKEYF10		0xca
#define KEYBOARDKEYF11		0xcb
#define KEYBOARDKEYF12		0xcc


// library screen
extern unsigned char	screenupdate;
unsigned char		*screensetresolution(unsigned int xsize, unsigned int ysize, unsigned int colourbits);


// library mouse
unsigned int	mousegetxcoo();
unsigned int	mousegetycoo();
unsigned int	mousegetbutton();


// class channel
unsigned char		*channelclose	(unsigned int channel);
unsigned int		channelin	(unsigned int channel);
void			channelout	(unsigned int channel, unsigned char value);


// class image
void imagegetsize	(unsigned int image,
			 unsigned int *xsize, unsigned int *ysize);
void imagesetpcolor	(unsigned int image,
			 unsigned int colourindex,
			 unsigned int rgbcolour);
void imagegetview	(unsigned int image,
			 int *xleft, int *ytop, int *xright, int *ydown);
void imagesetview	(unsigned int image,
			 int xleft,	int ytop,
			 int xright,	int ydown);
unsigned int imagegetpixel(unsigned int image,
			 int xcoo,	int ycoo);
void imageplot		(unsigned int image,
			 int xcoo,	int ycoo,
			 unsigned int rgbcolour);
void imagedrawline	(unsigned int image,
			 int x1,	int y1,
			 int x2,	int y2,
			 unsigned int rgbcolour);
void imagedrawcircle	(unsigned int image,
			 int xcoo,	int ycoo,
			 unsigned int radius,
			 unsigned int rgbcolour);
void imagefillcircle	(unsigned int image,
			 int xcoo,	int ycoo,
			 unsigned int radius,
			 unsigned int rgbcolour);
void imagefillcircler	(unsigned int image,
			 int xcoo,	int ycoo,
			 unsigned int radius,
			 unsigned int rgbcolour);
void imagedrawbox	(unsigned int image,
			 int xleft,	int ytop,
			 int xright,	int ydown,
			 unsigned int rgbcolour);
void imagefillbox	(unsigned int image,
			 int xleft,	int ytop,
			 int xright,	int ydown,
			 unsigned int rgbcolour);
void imagefillpolygon	(unsigned int image,
			 unsigned int numbpoints, void *pointertopointerlist,
			 unsigned int rgbcolour);

void imagegetcursor	(unsigned int image,	int *xcoo,	int *ycoo);
int  imagegetcursorx	(unsigned int image);
int  imagegetcursory	(unsigned int image);
void imagesetcursor	(unsigned int image,	int xcoo,	int ycoo);
void imagesettextcolor	(unsigned int image,
			 unsigned int rgbbackground,	unsigned int rgbforeground);
void imagegettextcolor	(unsigned int image,
			 unsigned int *rgbbackground,	unsigned int *rgbforeground);

void		imagesettextattribute(unsigned int image, unsigned int attribute);
unsigned int	imagegettextattribute(unsigned int image);

#define IMAGEUNDERLINE		1
#define IMAGEUPPERLINE		2
#define IMAGEBOLD		4
#define IMAGEITALIC		8
#define IMAGESHADOW		16
#define IMAGEDOUBLEHEIGHT	32
#define IMAGEDOUBLEWIDTH	64

unsigned char	*imagegetaddress(unsigned int image, unsigned int yline);
unsigned int	imagestringread	(unsigned int image, unsigned int keyboard,
				 unsigned char *stringptr, unsigned int maxlength);


// class window
unsigned char	*windowaddio(     int xcoo,	         int ycoo,
			 unsigned int xsize,	unsigned int ysize,
			 unsigned int outborder,unsigned int inborder,
			 unsigned char *namestring,
			 unsigned int  directmode,
			 unsigned int *keyboard,unsigned int *window);
unsigned char	*windowaddioxml		(unsigned int *keyboard, unsigned int *window, unsigned char *xmlpointer);
void		windowgetcoor		(unsigned int window, int *xcoo, int *ycoo);
void		windowsetcoor		(unsigned int window, int xcoo, int ycoo);
unsigned int	windowgetmove		(unsigned int window);
void		windowsetmove		(unsigned int window, unsigned int flag);
unsigned int 	windowgetpriority	(unsigned int window);
void		windowsetpriority	(unsigned int window, unsigned int flag);
unsigned int	windowgetvisibility	(unsigned int window);
void		windowsetvisibility	(unsigned int window, unsigned int flag);
unsigned int	windowgetclose		(unsigned int window);
void		windowsetclose		(unsigned int window, unsigned int flag);
void		windowgetmouse		(unsigned int window, int *mousex, int *mousey, unsigned int *mousebutton);


// library string
void		stringwrite		(unsigned int channel,	unsigned char *stringpointer);
unsigned char	*stringcopymessage	(unsigned char *deststring, unsigned char *message, unsigned int maxchars);
void		stringwritemessage	(unsigned int channel,	unsigned char *message);
unsigned char	*stringskiplf		(unsigned char *lastchar, void *stringptr);
unsigned int	stringtoint		(unsigned char *stringpointer);
int		stringcomparec		(unsigned char *string1, unsigned char *string2);


// libraries card32/int32
void		int32write		(unsigned int channel, int value);
int		int32read		(unsigned int keyboard, unsigned int window, int defaultvalue);
void		card32tohexd		(unsigned int hexvalue, unsigned char *stringpointer);
void		card32tohexdf		(unsigned int hexvalue, unsigned char *stringpointer);
unsigned int	card32readhex		(unsigned int keyboard, unsigned int window, unsigned int defaultvalue);


// library xml
unsigned char	*xmlcheckiden		(unsigned char *idenpointer,  unsigned char *lastcharacter, void *xmlpointer);
unsigned char	*xmlchecktag		(unsigned char *tagpointer,   unsigned char *lastcharacter, void *xmlpointer);
unsigned char	*xmlgetcomma		(unsigned char *lastcharacter, void *xmlpointer);
unsigned char	*xmlgetsemicolon	(unsigned char *lastcharacter, void *xmlpointer);
unsigned char	*xmlgetint32		(int	       *int32pointer, unsigned char *lastcharacter, void *xmlpointer);
unsigned char	*xmlgetstring		(unsigned int  maxlength,     unsigned char *destpointer,   unsigned char *lastcharacter, void *xmlpointer);


// message
unsigned char		*messageload	(unsigned char *filepath);	// load a message file into memory
unsigned char		*messageget	(unsigned char *messagename);	// get a pointer to a message within the text



// --> #ifndef DEF_INC_ASMLIB_H
#endif
