/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002- 2004 by the EMU][ Project/Dapple ][ Team
 *
 * $Header: /winc/emuiil/source/general.h,v 1.5 2003/08/30 10:22:29 dosius Exp $
 *
 * Component:  General: supporting methods and definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Log: general.h,v $
 * Revision ???
 * Z80 core development
 *
 */


/*----------------------------------------


	general supporting functions


	see general.c for implementation


----------------------------------------*/


#ifndef DEF_INC_GENERAL_H
#define DEF_INC_GENERAL_H


#define structpack __attribute__((packed))


// include asmlib if needed
#ifdef DEF_ASMLIB
#include "asmlib.h"
#endif


// typedefs for compatibility

#define int8		signed char
#define int16		signed short
#define int32		signed int
#define card8		unsigned char
#define card16		unsigned short
#define card32		unsigned int
#define pointer		void *
#define method		unsigned char *


// public constants

#define LOG_ALWAYS	0
#define LOG_VERBOSE	1
#define LOG_BRIEF	2
#define LOG_MESSAGE	3


// standard supporting functions
int			strright	(char *tgt, char *src);

unsigned char		*card8tohex	(card8 value, unsigned char *pstringptr[]);

unsigned char		*taskopen	(void);
unsigned char		*taskclose	(void);
void			taskswitch	(void);
unsigned char		*taskgeterror	(void);
unsigned char		*taskseterror	(unsigned char *stringptr);
unsigned char		*taskclearerror	(void);
#ifdef DEF_INC_ASMLIB_H
void			tasklogsetchannel(unsigned int channel);
#endif
void			tasklogreturn	(unsigned int mode);
void			tasklogstring	(unsigned int mode, unsigned char *stringptr);
void			tasklogmessage	(unsigned int mode, unsigned char *stringptr);
void			tasklogint32	(unsigned int mode, int32 value);
void			taskloghex32	(unsigned int mode, int32 value);
unsigned char		*tasklogerror	(unsigned int mode, unsigned char *stringptr);

#ifndef DEF_INC_GENERAL_C
extern	FILE		*tasklogfile;
extern	unsigned char	tasklogpause;
#endif

unsigned char		*fileload(unsigned char *filename, unsigned int numbbytes, unsigned int *bytesread, void *memoryptr);
unsigned char		*filesave(unsigned char *filename, unsigned int numbbytes, unsigned int *byteswritten, void *memoryptr);
unsigned char		*fileresident(unsigned char *filename, void *fileptr[], unsigned int *size);
unsigned char		*fileloadtext(unsigned char *filepath, unsigned char replace, unsigned char *textptr[], unsigned int *size);


unsigned char		*bmp24_check	(card8 *bmpptr);
unsigned char		*bmp24_getsize	(card8 *bmpptr, unsigned int *xsize, unsigned int *ysize);
#ifdef DEF_INC_ASMLIB_H
unsigned char		*bmp24_draw	(card8 *bmpptr, unsigned int image, int xcoo, int ycoo);
#endif


// --> #ifndef DEF_INC_GENERAL_H
#endif
