/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component: CPU65C02: CPU emulation
 * ADC and SBC instructions contributed by Scott Hemphill.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */

/*----------------------------------------


        65c02 emulation


        see cpu65c02.c for implementation


----------------------------------------*/


#ifndef DEF_INC_CPU65C02_H
#define DEF_INC_CPU65C02_H



// **** include general libraries concerning definitions

//#ifndef DEF_ASMLIB
//#define DEF_ASMLIB            // set by dapple.h
//#endif

//#include <stdio.h>            // included by dapple.h
//#include <string.h>           // included by dapple.h
//#include "..\libs\general.h"  // included by dapple.h
//#include "..\libs\asmlib.h"   // included by dapple.h
#include "dapple.h"


// **** public constants

// type of CPU
#define CPU_6502        0x01
#define CPU_65C02       0x02
#define CPU_65SC02      0x04
#define CPU_Z80         0x08

// cpu state
#define CPU_STATEHALT   0x0001
#define CPU_STATERESET  0x0002
#define CPU_STATEGURU   0x0004
#define CPU_STATEBPT    0x0008
#define CPU_STATEBRK    0x0010
#define CPU_STATETRACE  0x0020
#define CPU_STATECOP    0x0040
#define CPU_STATEIRQ1   0x0100
#define CPU_STATEIRQ2   0x0200
#define CPU_STATENMI1   0x1000
#define CPU_STATENMI2   0x2000


// **** public functions

unsigned char   *cpuinit        (void);                         // initialize emulation
unsigned char   *cpuclose       (void);                         // end emulation
unsigned char   *cpureset       (void);                         // reset c6502

unsigned char   *cpustore       (unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   *cpurestore     (unsigned int winprotocol, FILE *file, unsigned int percent);

unsigned int    cpugettype      (void);
void            cpusettype      (unsigned int value);

unsigned int    cpugetstate     (void);
void            cpusetstate     (unsigned int value);           // e.g. set RESET, IRQ, NMI etc
void            cpuclearstate   (unsigned int value);           // e.g. clear RESET, IRQ, NMI etc
void            cpufastsethalt  (void);
void            cpufastclearhalt(void);
unsigned int    cpugetbreakpoint(void);
void            cpusetbreakpoint(unsigned int value);
void            cpuclearbreakpoint(void);
unsigned int    cpugettracemode (void);
void            cpusettracemode (unsigned int value);
unsigned char   cpuinuse        (void);

unsigned int    cpugeta         (void);                         // access 6502 registers through these functions
void            cpuseta         (unsigned int value);
unsigned int    cpugetx         (void);
void            cpusetx         (unsigned int value);
unsigned int    cpugety         (void);
void            cpusety         (unsigned int value);
unsigned int    cpugetpc        (void);
void            cpusetpc        (unsigned int address);
unsigned int    cpugetsp        (void);
void            cpusetsp        (unsigned int address);

unsigned int    cpugetcycle     (void);
void            cpusetcycle     (unsigned int value);
unsigned int    cpugetlastcycle (void);
void            cpusetlastcycle (unsigned int value);
unsigned int    cpugetlinecycle (void);
void            cpusetlinecycle (unsigned int value);
unsigned int    cpugetdelay     (void);
void            cpusetdelay     (unsigned int value);

void            cpulight        (unsigned char value);          // draw little cpu-on indicator on screen

void            cpuflagssetnz   (unsigned int value);           // set N and Z according to value
card8           cpugetflags     (void);                         // get a byte with flags as seen from within 6502
void            cpusetflags     (unsigned int value);           // set all flags except b according to value
void            cpuflagstostring(unsigned int value, unsigned char *stringptr);

unsigned char   cpupullstack    (void);
void            cpupushstack    (unsigned int value);

unsigned int    cpuline         (void);
void            cpuwriteregs    (unsigned int window);

#ifdef DEF_ASMLIB
void            cpumenu         (void);
#endif

#ifdef CPU_ASM
void            cpu6502init     (void);
void            cpu6502reset    (void);
void            cpu6502line     (void);
#endif


// **** public global variables

extern  card8           areg;           // Accumulator
extern  card8           xreg;           // X-Register
extern  card8           yreg;           // Y-Register
extern  card8           stack;          // Stack-Register
extern  card16          pc;             // Program counter
extern  card8           nflag;          // N-Flag
extern  card8           vflag;          // Overflow-Flag
extern  card8           iflag;          // Interrupt-Flag
extern  card8           bflag;          // Break-Flag
extern  card8           dflag;          // Decimal-Flag
extern  card8           zflag;          // Zero-Flag
extern  card8           cflag;          // Carry-Flag
extern  unsigned int    stateflags;     // current IRQ/NMI flags etc

extern  unsigned int    cpuregswindow;
extern  unsigned char   cpumessageflag;


// --> #ifndef DEF_INC_CPU65C02_H
#endif
