/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * This component last revised 2003.0628 (0.30 Final)
 *
 * Component:  Header file for Dapple shared components
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#ifndef DEF_INC_DAPPLE_H
#define DEF_INC_DAPPLE_H


// include Z80 emulation
// #define EMUZ80

// do we want cycle exact emulation of the 6502?
//#define CPU_CYCLEEXACT

// do we want the 80x86 assembly core to be included?
//#define CPU_ASM
// note: don't use CPU_CYCLEEXACT together with CPU_ASM


// do we want the REE to be included?
//#define REECOP
// note: don't use REECOP together with CPU_ASM or CPU_CYCLEEXACT


// **** include general libraries concerning definitions

#ifndef DEF_ASMLIB
#define DEF_ASMLIB
#endif

#include <stdio.h>
#include <string.h>
#include "..\libs\general.h"
//#include "..\libs\asmlib.h"	// found in general.h





// **** definitions for slot handling ****

#define	SLOTTYPENONE		0
#define SLOTTYPEPARALLEL	1
#define SLOTTYPEMOUSE		2
#define SLOTTYPEZ80		3
#define SLOTTYPEMASSSTORE	4
#define	SLOTTYPEDISKDRIVE	5


// prototypes
unsigned char *slotnofunction	(void *slotdata);
unsigned char *slotnostore	(void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char *slotnorestore	(void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char slotnoget		(void *slotdata, unsigned int address);
void	      slotnoset		(void *slotdata, unsigned int address, unsigned int val);
unsigned char slotnoromget	(void *slotdata, unsigned int address);
void	      slotnoromset	(void *slotdata, unsigned int address, unsigned int val);

typedef struct {
unsigned char *(*slotclose)	(void *slotdata);					// close slot
unsigned char *(*slotreset)	(void *slotdata);					// reset slot
unsigned char *(*slotstore)	(void *slotdata, unsigned int window, FILE *file, unsigned int percent); // store slot
unsigned char *(*slotrestore)	(void *slotdata, unsigned int window, FILE *file, unsigned int percent); // restore slot
unsigned char (*slotget)	(void *slotdata, unsigned int address);			// read byte from softswitch
void          (*slotset)	(void *slotdata, unsigned int address, unsigned int val);// write byte to softswitch
unsigned char (*slotromget)	(void *slotdata, unsigned int address);			// read byte from slotrom
void          (*slotromset)	(void *slotdata, unsigned int address, unsigned int val);// write byte to slotrom
unsigned char *(*slotmenu)	(void *slotdata);					// standard menu
unsigned char *(*slotshift)	(void *slotdata);					// <Shift-Fx>
unsigned char *(*slotctrl)	(void *slotdata);					// <Ctrl-Fx>
unsigned char *(*slotshiftctrl)	(void *slotdata);					// <Shift-Ctrl-Fx>
void	      *slotdata;								// specific slot data
unsigned char slottype;									// type of slot
unsigned char *slotname;								// name of slot
} slot;





// **** public constants

// type of apple
#define APPLEII 1
#define APPLEIIE 2
#define APPLEIIC 4
#define LASER128 8

// window size of standard menus
#define WINDOWXSIZE 512
#define WINDOWYSIZE 256

// slot drive lights
#define SLOTX1 628
#define SLOTX2 632
#define SLOT5Y 10
#define SLOT6Y 14
#define RGBLGHTON 0xff0000
#define RGBLGHTOFF 0x404040

// Color definitions

// Lo-res graphics
#define COL_LGR0 0xc0
#define COL_LGR1 0xc1
#define COL_LGR2 0xc2
#define COL_LGR3 0xc3
#define COL_LGR4 0xc4
#define COL_LGR5 0xc5
#define COL_LGR6 0xc6
#define COL_LGR7 0xc7
#define COL_LGR8 0xc8
#define COL_LGR9 0xc9
#define COL_LGRA 0xca
#define COL_LGRB 0xcb
#define COL_LGRC 0xcc
#define COL_LGRD 0xcd
#define COL_LGRE 0xce
#define COL_LGRF 0xcf

// Hi-res graphics
#define COL_HGR0 0xd0
#define COL_HGR1 0xd1
#define COL_HGR2 0xd2
#define COL_HGR3 0xd3
#define COL_HGR4 0xd4
#define COL_HGR5 0xd5
#define COL_HGR6 0xd6
#define COL_HGR7 0xd7

// Text mode
#define COL_TXT_WHT0 0xd8
#define COL_TXT_WHT1 0xd9
#define COL_TXT_GRN0 0xda
#define COL_TXT_GRN1 0xdb
#define COL_TXT_AMB0 0xdc
#define COL_TXT_AMB1 0xdd


// **** public type definitions

typedef enum {USA, France, Germany, UK, Denmark1, Sweden, Italy, Spain,
              Japan, Norway, Denmark2, None} Charset;


// **** public functions

void		cwdxchgslash	(unsigned char *stringptr, unsigned int value);
void		getpathstring	(unsigned char *destptr, unsigned char *sourceptr);
unsigned char	keyboardyesno	(unsigned int keyboard, unsigned int window);
void		stringwritecenterx(unsigned int window, unsigned char *stringptr);
void		stringwriteyesno(unsigned int window, unsigned char value);
void		stringwriteonoff(unsigned int window, unsigned char value);
unsigned char	*stringgeterror	(void);
unsigned char	*windowprotocol	(unsigned int *keyboard, unsigned int *window, unsigned char *title);
void		windowpresskey	(unsigned int keyboard, unsigned int window);
void		setmessage	(unsigned char *message);
unsigned int	fileselectmenu	(unsigned char *windowtitle, unsigned char *title,
				 unsigned char *filename, unsigned char *filepath, unsigned char *tail,
				 unsigned char optnew);

unsigned char	*appleinit	(void);
unsigned char	*appleclose	(void);
unsigned char	*applereset	(void);
unsigned char	*applestore	(unsigned char *filename);
unsigned char	*applerestore	(unsigned char *filename);
unsigned char	*applevblank	(void);

void		keyboardinit	(void);
unsigned char	*keyboardstore	(unsigned int window, FILE *file, unsigned int percent);
unsigned char	*keyboardrestore(unsigned int window, FILE *file, unsigned int percent);
void		keyboardmenu	(void);

void		quitmenu	(void);

void		mainmenu	(void);


// **** public global variables

extern	unsigned char	*fatalerror;	// pointer to error message of fatal error
extern	unsigned int	screen_xsize;	// screen x resolution
extern	unsigned int	screen_ysize;	// screen y resolution
extern	unsigned int	keyboard;	// basic keyboard handle
extern	unsigned int	window;		// basic window handle
extern	unsigned int	cpuregskeyboard;// keyboard handle for cpuwindow
extern	unsigned int	cpuregswindow;	// window handle for logwindow

extern	unsigned char	cpuflag;	// 6502 or Z80
extern	unsigned char	appletype;	// II+/IIe/IIc
extern	unsigned char	messageflag;	// allow bottom messages?
extern	unsigned char	callingpath[260];


extern	unsigned char	keycapslock;	// capslock mode on?
extern	unsigned char	keygerman;	// switch 'Y' and 'Z' on German keyboards?
extern	unsigned char	keybs;		// switch <BS> and <DEL> ?
extern	unsigned char	keyjoystick;	// numeric keypad or real joystick?

extern	unsigned char	inirompath[260];
extern	unsigned char	inistatepath[260];
extern	unsigned char	inidiskpath1[260];
extern	unsigned char	inidiskpath2[260];
extern	unsigned int	inicpudelay;
extern	unsigned char	inimenulanguage;// language on screen
extern	unsigned char	inidebugflag;	// debugger on?
extern	Charset		inicharmode;

extern	slot		slots[8];


// --> #ifndef DEF_INC_DAPPLE_H
#endif
