/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002- 2004 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  GUI: main menu, global functions, keyboard emulation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */

/*----------------------------------------


        gui.c


        see include file gui.h for definitions


----------------------------------------*/


#ifndef DEF_INC_GUI_C
#define DEF_INC_GUI_C


// **** include general definition files


//#ifndef DEF_ASMLIB
//#define DEF_ASMLIB            // set by dapple.h
//#endif

//#include <stdio.h>            // included by dapple.h
//#include "..\libs\general.h"  // included by dapple.h
//#include "..\libs\asmlib.h"   // included by dapple.h
#include "dapple.h"


// **** include definition file of this source

#include "gui.h"




/*--------------------------------------

 void   guishadowbox    (window : POINTER; xleft : INTEGER, ytop : INTEGER; xright : INTEGER; ydown : INTEGER;
                         darkcolour : CARDINAL, lightcolour : CARDINAL)

 ---------------------------------------*/

      void guishadowbox (unsigned int window,
                         unsigned int xleft, unsigned int ytop, unsigned int xright, unsigned int ydown,
                         unsigned int darkcolour, unsigned int lightcolour) {

        imagefillbox(window, xleft,     ytop,   xright, ytop,   darkcolour);
        imagefillbox(window, xleft,     ydown,  xright, ydown,  lightcolour);
        imagefillbox(window, xleft,     ytop,   xleft,  ydown,  darkcolour);
        imagefillbox(window, xright,    ytop,   xright, ydown,  lightcolour);

      } // guishadowbox


/*--------------------------------------

 void guiinbox  (unsigned int window, unsigned int xleft, unsigned int ytop, unsigned int xright, unsigned int ydown)

        draw a shadowed 'in'-box
        RGB-values for box are defined in gui.h

 ---------------------------------------*/

      void guiinbox(unsigned int window, unsigned int xleft, unsigned int ytop, unsigned int xright, unsigned int ydown) {

        imagefillbox(window, xleft,     ytop,   xright, ytop,   RGBDGREY);
        imagefillbox(window, xleft,     ydown,  xright, ydown,  RGBLGREY);
        imagefillbox(window, xleft,     ytop,   xleft,  ydown,  RGBDGREY);
        imagefillbox(window, xright,    ytop,   xright, ydown,  RGBLGREY);

      } // guiinbox


/*--------------------------------------

 void   guioutbox       guioutbox(unsigned int window, unsigned int xleft, unsigned int ytop, unsigned int xright, unsigned int ydown)

        draw a shadowed 'in'-box
        RGB-values for box are defined in gui.h

 ---------------------------------------*/

      void guioutbox(unsigned int window, unsigned int xleft, unsigned int ytop, unsigned int xright, unsigned int ydown) {

        imagefillbox(window, xleft,     ytop,   xright, ytop,   RGBLGREY);
        imagefillbox(window, xleft,     ydown,  xright, ydown,  RGBDGREY);
        imagefillbox(window, xleft,     ytop,   xleft,  ydown,  RGBLGREY);
        imagefillbox(window, xright,    ytop,   xright, ydown,  RGBDGREY);

      } // guioutbox


/*--------------------------------------

 void   guipercent      (unsigned int window, unsigned int value, unsigned char *message)

        draw a percentage bar

 ---------------------------------------*/


      void guipercent(unsigned int window, unsigned int value, unsigned char *message) {
        const unsigned int XLEFT  = 16;
        const unsigned int XRIGHT = 480 - 16;
        const unsigned int YTOP   = 128 - 25;
        const unsigned int YDOWN  = 128 - 15;

        unsigned int loopxleft;
        unsigned int loopxright;
        unsigned int loopxrightmax;
        unsigned int loopcolour;
        unsigned int oldcursorx;
        unsigned int oldcursory;

        imagesetview(window, 0, 0, 479, 127);
// draw outer border
        guiinbox        (window, XLEFT - 1, YTOP - 1, XRIGHT + 1, YDOWN + 1);
// draw bar background
        imagefillbox    (window, XLEFT    , YTOP    , XRIGHT    , YDOWN    , 0x304050);


        if (value > 100) {
          value = 100;
        }
        loopxrightmax = XLEFT + (unsigned int)(((XRIGHT - XLEFT) * value) / 100) - 2;

        loopcolour = 0x7080a0;
        for (loopxleft = XLEFT + 1; loopxleft < loopxrightmax;) {
          loopxright = loopxleft + 5;
          if (loopxright > loopxrightmax) {
            loopxright = loopxrightmax;
          }
          imagefillbox(window, loopxleft, YTOP + 1, loopxright - 1, YDOWN - 1, loopcolour);
          if (loopcolour == 0x7080a0) {
            loopcolour = 0x607090;
          }
          else {
            loopcolour = 0x7080a0;
          }
          loopxleft = loopxright;
        } // for (loopxleft)
        imagefillbox(window, loopxleft, YTOP + 1, loopxleft + 1, YDOWN - 1, 0x506070);

        oldcursorx = imagegetcursorx(window);
        oldcursory = imagegetcursory(window);
        if (value < 10) {
          loopxleft = 2*8;
        }
        else {
          if (value < 100) {
            loopxleft = 3*8;
          }
          else {
            loopxleft = 4*8;
          }
        }
        imagesetcursor(window, XLEFT + (((XRIGHT - XLEFT) - loopxleft) / 2), YDOWN - 1);
        imagesettextcolor(window, -1, 0xffffff);
        int32write(window, value);
        channelout(window, '%');
        imagesetcursor(window, oldcursorx, oldcursory);

        imagesetview(window, XLEFT, 24, XRIGHT, 24+63);
        imagesettextcolor(window, 0x808090, 0xffff00);
        stringwritemessage(window, message);
        channelout(window, 13);

        screenupdate = 1;
        taskswitch();

      } // guipercent


/*--------------------------------------

 unsigned char  guiyesno        (unsigned int keyboard, unsigned int window)

        draw a two button for 'yes' and 'no'.
        return 0 for no
        return 1 for yes

 ---------------------------------------*/


      unsigned char guiyesno(unsigned int keyboard, unsigned int window) {
        const unsigned int buttonxsize = 64;
        const unsigned int buttonysize = 12;

        unsigned int xsize;
        unsigned int ysize;
        int yesleft, yestop, yesright, yesdown;
        int noleft,  notop,  noright,  nodown;
        int mousex, mousey, mousebutton;
        register unsigned char inbox;
        register unsigned char key;

        imagegetsize(window, &xsize, &ysize);
        xsize = xsize >> 1;
        yesleft  = xsize - 16 - buttonxsize;
        yesright = yesleft + buttonxsize - 1;
        noleft   = xsize + 16;
        noright  = noleft  + buttonxsize - 1;
        yestop   = ysize  - 20;
        yesdown  = yestop + buttonysize - 1;
        notop    = ysize  - 20;
        nodown   = notop  + buttonysize - 1;
        guioutbox(window, yesleft, yestop, yesright, yesdown);
        guioutbox(window, noleft,  notop,  noright,  nodown);
        imagesetcursor(window, yesleft + 1, yesdown - 1);
        stringwritemessage(window,
"!\
E Y(es;\
G  J(a;\
");
        imagesetcursor(window, noleft + 1, nodown - 1);
        stringwritemessage(window,
"!\
E  N(o;\
G N(ein;\
");

        screenupdate = 1;

        do {
          do {
            taskswitch();
            windowgetmouse(window, &mousex, &mousey, &mousebutton);
            if (mousebutton && 1) {
              if ((mousex >= yesleft) && (mousex <= yesright) && (mousey >= yestop) && (mousey <= yesdown)) {
                guiinbox(window, yesleft, yestop, yesright, yesdown);
                screenupdate = 1;
                do {
                  taskswitch();
                  windowgetmouse(window, &mousex, &mousey, &mousebutton);
                  inbox = ((mousex >= yesleft) && (mousex <= yesright) && (mousey >= yestop) && (mousey <= yesdown));
                }
                while ((mousebutton && 1) && (!exitprogram) && (inbox));
                guioutbox(window, yesleft, yestop, yesright, yesdown);
                if (inbox) {
                  if (exitprogram) {
                    return 0;
                  }
                  else {
                    return 1;
                  }
                }
              }
              if ((mousex >= noleft) && (mousex <= noright) && (mousey >= notop) && (mousey <= nodown)) {
                guiinbox(window, noleft, notop, noright, nodown);
                screenupdate = 1;
                do {
                  taskswitch();
                  windowgetmouse(window, &mousex, &mousey, &mousebutton);
                  inbox = ((mousex >= noleft) && (mousex <= noright) && (mousey >= notop) && (mousey <= nodown));
                }
                while ((mousebutton && 1) && (!exitprogram) && (inbox));
                guioutbox(window, noleft, notop, noright, nodown);
                if (inbox) {
                  return 0;
                }
              }
            }
            if (windowgetclose(window)) {
              key = 27;
            }
            else {
              key = (unsigned char)channelin(keyboard);
            }
          }
          while ((key == 0) && (!exitprogram));
          if ((key == 27) || (key == 32)) {
            return 0;
          }
          if (inimenulanguage == 'E') {
            switch (key) {
              case 'n' :
              case 'N' :
                return 0;
              case 'y' :
              case 'Y' :
                return 1;
            }
          }
          else {
            switch (key) {
              case 'n' :
              case 'N' :
                return 0;
              case 'j' :
              case 'J' :
                return 1;
            }
          }
        }
        while (!exitprogram);
        return 0;

      } // guiyesno


// --> #ifndef DEF_INC_GUI_C
#endif
