/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  INI: EMUII.INI/DAPPLE2.INI file handling
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Bug fixes
 *           Z80 core development
 *
 */


/*----------------------------------------


        ini.c


        see include file ini.h for definitions


----------------------------------------*/


#ifndef DEF_INC_INI_C
#define DEF_INC_INI_C


// **** include general definition files

//#include <stdio.h>            // included by ini.h
//#include <string.h>           // included by ini.h
//#include "..\libs\asmlib.h"   // included by ini.h
//#include "..\libs\general.h"  // included by ini.h
//#include "dapple.h"           // included by ini.h


// **** include definition file of this source

#include "ini.h"


// **** include further Emu][ specific files

#include "cpu65c02.h"
#include "disk.h"
#include "gui.h"
#include "lldisk.h"
#include "memory.h"
#include "mouse.h"
#include "pic.h"
#include "video.h"
#ifdef EMUZ80
#include "z80.h"
#endif






/*----------------------------------------

 error  writeini        (void)

        write preferences to ini file

----------------------------------------*/

      unsigned char *writeini(void) {
        unsigned int            keyboard;
        unsigned int            window;
        register FILE           *file;
        register unsigned char  vpal;
        register unsigned char  vmono;
        register unsigned char  vtmode;
        register unsigned char  vlmode;
        register unsigned char  vhmode;
        register unsigned char  vdhmode;
        register Charset        vcharset;
        register unsigned char  cputype;
        register unsigned char  cpuregsflag;
        register unsigned char  *error;


        if ((windowprotocol(&keyboard, &window,
"!\
EWrite Ini File;\
GSchreibe Ini-Datei;\
")))    {
          exitprogram = 1;              // severe error ==> die
          return tasklogerror(LOG_ALWAYS, "'writeini'-protocol window could not be opened.");
        }

        file = fopen("emu2.ini","wt");
        if (file == NULL) {
          error =
"!\
EError while opening ini file.;\
GFehler beim ffnen der Ini-Datei.;\
";
          stringwritemessage(window, error);
          channelout(window, 13);
          windowpresskey(keyboard, window);
          channelclose(keyboard);
          channelclose(window);
          return tasklogerror(LOG_ALWAYS, error);
        }

        vpal     = virtgetpalette();
        vmono    = virtgetmonochrome();
        vtmode   = virtgettextmode();
        vlmode   = virtgetlresmode();
        vhmode   = virtgethresmode();
        vdhmode  = virtgetdhrsmode();
        vcharset = virtgetcharset();
        cputype  = cpugettype();
        if (cpuregswindow) {
          cpuregsflag = windowgetvisibility(cpuregswindow);
        }
        else {
          cpuregsflag = 0;
        }

        guipercent(window, 0,
"!\
EOpening ini file...;\
Gffne Ini-Datei...;\
");

        guipercent(window, 2,
"!\
EWrite information...;\
GSchreibe Informationen...;\
");

        fprintf(file,"[ Emu][ ]\n");

// keyboard
        guipercent(window, 5,
"!\
EWrite keyboard data...;\
GSchreibe Tastaturdaten...;\
");
        fprintf(file,"\n; ---- Keyboard ----\n\n");
        fprintf(file,"CapsLock=%s\n",   keycapslock?    "Yes":"No");
        fprintf(file,"SwitchYZ=%s\n",   keygerman?      "Yes":"No");
        fprintf(file,"SwitchBS=%s\n",   keybs?          "Yes":"No");
        fprintf(file,"Layout=%s\n",     keyboardgetlayout()?    "Germany":"USA");
        fprintf(file,"Joystick=%s\n",   keyjoystick?    "Joystick":"NumericKeypad");

// sound
        guipercent(window, 10,
"!\
EWrite sound data...;\
GSchreibe Sounddaten...;\
");
        fprintf(file,"\n; ---- Sound ----\n\n");
        fprintf(file,"Sound=%s\n",      soundflag?"Yes":"No");

// video
        guipercent(window, 20,
"!\
EWrite video data...;\
GSchreibe Videodaten...;\
");
        fprintf(file,"\n; ---- Video ----\n\n");
        fprintf(file,"Monitor=%s\n",    vmono==0?       "Color":
                                        vmono==1?       "Mono":
                                        vmono==2?       "Green":
                                                        "Amber");
        fprintf(file,"Palette=%s\n",    vpal==0?        "IIgs":
                                        vpal==1?        "Standard":
                                        vpal==2?        "ApplePC":
                                                        "Gray");
        fprintf(file,"TextMode=%s\n",   vtmode==0?      "Standard":
                                                        "Blurry");
        fprintf(file,"LoResMode=%s\n",  vlmode==0?      "Standard":
                                                        "Blurry");
        fprintf(file,"HiResMode=%s\n",  vhmode==0?      "Composite":
                                        vhmode==1?      "RGB":
                                                        "Blurry");
        fprintf(file,"DHiResMode=%s\n", vdhmode==0?     "560":
                                        vdhmode==1?     "140":
                                                        "RGB");
        fprintf(file,"Charset=%s\n",    vcharset==USA     ?"USA":
                                        vcharset==France  ?"France":
                                        vcharset==Germany ?"Germany":
                                        vcharset==UK      ?"UK":
                                        vcharset==Denmark1?"Denmark1":
                                        vcharset==Sweden  ?"Sweden":
                                        vcharset==Italy   ?"Italy":
                                        vcharset==Spain   ?"Spain":
                                        vcharset==Japan   ?"Japan":
                                        vcharset==Norway  ?"Norway":
                                        vcharset==Denmark2?"Denmark2":
                                                           "???");
        fprintf(file,"Scanline=%s\n",   virtscanline==0 ?"None":
                                        virtscanline==1 ?"Half":
                                                         "Full");
        fprintf(file,"DoubleView=%s\n", virtdouble?"Yes":"No");

// memory
        guipercent(window, 30,
"!\
EWrite memory data...;\
GSchreibe Speicherdaten...;\
");
        fprintf(file,"\n; ---- Memory ----\n\n");
        fprintf(file,"DefaultBIOS=%s\n",memrompath);
        fprintf(file,"LanguageCard=%s\n", memnolc ? "No":"Yes");
        fprintf(file,"ClearPattern=%s\n", memorygetclearmode()==0 ? "None":
                                          memorygetclearmode()==1 ? "00":
                                          memorygetclearmode()==2 ? "00FF":
                                          memorygetclearmode()==3 ? "FF00":
                                          memorygetclearmode()==4 ? "EA":
                                          memorygetclearmode()==5 ? "0001":
                                          memorygetclearmode()==6 ? "DEADBEEF":
                                                                    "EFBEADDE");
        fprintf(file,"IIC4080=%d\n", memiic4080?80:40);

// cpu
        guipercent(window, 40,
"!\
EWrite cpu data...;\
GSchreibe Cpu-Daten...;\
");
        fprintf(file,"\n; ---- CPU ----\n\n");
        fprintf(file,"Delay=$%04X\n", inicpudelay);
        fprintf(file,"CPU=%s\n",        cpugettype()==CPU_6502  ?"6502":
                                        cpugettype()==CPU_65C02 ?"65C02":
                                                                 "65SC02");
        fprintf(file,"ShowRegs=%s\n",   cpuregsflag             ?"Yes":"No");
        fprintf(file,"ShowMessage=%s\n",cpumessageflag          ?"Yes":"No");

// parallel
        guipercent(window, 50,
"!\
EWrite parallel interface data...;\
GSchreibe Parellelschnittstelledaten...;\
");
        fprintf(file,"\n; ---- Parallel ----\n\n");
        fprintf(file,"Parallel=%s\n",parallelactive?"Activated":"Deactivated");

// mouse
        guipercent(window, 60,
"!\
EWrite mouse data...;\
GSchreibe Mausdaten...;\
");
        fprintf(file,"\n; ---- Mouse ----\n\n");
        fprintf(file,"Mouse=%s\n",mouseactive?"Activated":"Deactivated");

#ifdef EMUZ80
// Z80
        guipercent(window, 65,
"!\
EWrite Z80 data...;\
GSchreibe Z80-Daten...;\
");
        fprintf(file,"\n; ---- Z80 ----\n\n");
        fprintf(file,"Z80=%s\n",z80active?"Activated":"Deactivated");
#endif

// mass store
        guipercent(window, 70,
"!\
EWrite mass store data...;\
GSchreibe Massenspeichergertdaten...;\
");
        fprintf(file,"\n; ---- Mass Store ----\n\n");
        fprintf(file,"MassStore=%s\n",lldiskactive?"Activated":"Deactivated");

// drive
        guipercent(window, 80,
"!\
EWrite disk drive data...;\
GSchreibe Diskettenlaufwerkdaten...;\
");
        fprintf(file,"\n; ---- Drive ----\n\n");
        fprintf(file,"Disk1=%s\n",inidiskpath1);
        fprintf(file,"Disk2=%s\n",inidiskpath2);
        fprintf(file,"DriveFastMode=%s\n",drivefastflag?"Yes":"No");
        fprintf(file,"DriveMessage=%s\n",drivemessageflag?"Yes":"No");

// miscellaneous
        guipercent(window, 90,
"!\
EWrite miscellaneous data...;\
GSchreibe sonstige Daten...;\
");
        fprintf(file,"\n; ---- Miscellaneous ----\n\n");
        fprintf(file,"StatePath=%s\n",inistatepath);
        fprintf(file,"MenuLanguage=%s\n",inimenulanguage=='E'   ?"English":
                                                                 "German");

/*
        fprintf(file,"JoyCalibrateMinX=%u\n",GameMinX);
        fprintf(file,"JoyCalibrateMinY=%u\n",GameMinY);
        fprintf(file,"JoyCalibrateMaxX=%u\n",GameMaxX);
        fprintf(file,"JoyCalibrateMaxY=%u\n",GameMaxY);
 */


        fclose(file);

        guipercent(window, 100,
"!\
EIni file written.;\
GIni-Datei geschrieben.;\
");

//      windowpresskey(keyboard, window);
        channelclose(keyboard);
        channelclose(window);

        return NULL;    // no error

      } // writeini


/*----------------------------------------

 error  readini (void)

        read preferences from ini file

----------------------------------------*/

      unsigned char *readini(void) {
        unsigned int  keyboard;
        unsigned int  window;
        unsigned char wip[128];
        register FILE *file;
        register unsigned char *error;
        register unsigned char vpal;
        register unsigned char vmono;
        register unsigned char vtmode;
        register unsigned char vlmode;
        register unsigned char vhmode;
        register unsigned char vdhmode;
        register Charset       vcharset;
        register unsigned char cpuregsflag;

        if ((windowprotocol(&keyboard, &window,
"!\
ERead Ini File;\
GLese Ini-Datei;\
")))    {
          exitprogram = 1;              // severe error ==> die
          return tasklogerror(LOG_ALWAYS, "'readini'-protocol window could not be opened.");
        }

        guipercent(window, 0,
"!\
EOpening ini file...;\
Gffne Ini-Datei...;\
");
        file = fopen("emu2.ini","rt");
        if (file == NULL) {
          error =
"!\
EError while opening ini file.;\
GFehler beim ffnen der Ini-Datei.;\
";
          stringwritemessage(window, error);
          channelout(window, 13);
          windowpresskey(keyboard, window);
          channelclose(keyboard);
          channelclose(window);
          return tasklogerror(LOG_ALWAYS, error);
        }

        vpal     = 0xff;
        vmono    = 0xff;
        vtmode   = 0xff;
        vlmode   = 0xff;
        vhmode   = 0xff;
        vdhmode  = 0xff;
        vcharset = None;
        cpuregsflag = 0;

        guipercent(window, 25,
"!\
EReading ini file...;\
GLese Ini-Datei...;\
");
        while (!feof(file)) {

          fgets(wip,128,file);
          wip[strlen(wip)-1]=0;

// keyboard
          if (!stricmp(wip,"CapsLock=Yes"))     keycapslock = 1;
          if (!stricmp(wip,"CapsLock=No"))      keycapslock = 0;
          if (!stricmp(wip,"SwitchYZ=Yes"))     keygerman = 1;
          if (!stricmp(wip,"SwitchYZ=No"))      keygerman = 0;
          if (!stricmp(wip,"SwitchBS=Yes"))     keybs = 1;
          if (!stricmp(wip,"SwitchBS=No"))      keybs = 0;
          if (!stricmp(wip,"Layout=USA"))       keyboardsetlayout(0);
          if (!stricmp(wip,"Layout=Germany"))   keyboardsetlayout(1);
          if (!stricmp(wip,"Joystick=Joystick"))keyjoystick = 1;
          if (!stricmp(wip,"Joystick=NumericKeypad"))keyjoystick = 0;

// sound
          if (!stricmp(wip,"Sound=Yes"))        soundflag = 1;
          if (!stricmp(wip,"Sound=No"))         soundflag = 0;

// video
          if (!stricmp(wip,"Monitor=Color"))    vmono = 0;
          if (!stricmp(wip,"Monitor=Mono"))     vmono = 1;
          if (!stricmp(wip,"Monitor=Green"))    vmono = 2;
          if (!stricmp(wip,"Monitor=Amber"))    vmono = 3;

          if (!stricmp(wip,"Console=Color"))    vmono = 0;
          if (!stricmp(wip,"Console=Amber"))    vmono = 3;

          if (!stricmp(wip,"Palette=IIgs"))     vpal = 0;
          if (!stricmp(wip,"Palette=Standard")) vpal = 1;
          if (!stricmp(wip,"Palette=ApplePC"))  vpal = 2;
          if (!stricmp(wip,"Palette=Gray"))     vpal = 3;

          if (!stricmp(wip,"TextMode=Standard"))        vtmode = 0;
          if (!stricmp(wip,"TextMode=Blurry"))          vtmode = 1;

          if (!stricmp(wip,"LoResMode=Standard"))       vlmode = 0;
          if (!stricmp(wip,"LoResMode=Blurry"))         vlmode = 1;

          if (!stricmp(wip,"HiResMode=Composite"))      vhmode = 0;
          if (!stricmp(wip,"HiResMode=RGB"))            vhmode = 1;
          if (!stricmp(wip,"HiResMode=Blurry"))         vhmode = 2;

          if (!stricmp(wip,"DHiResMode=560"))           vdhmode = 0;
          if (!stricmp(wip,"DHiResMode=140"))           vdhmode = 1;
          if (!stricmp(wip,"DHiResMode=RGB"))           vdhmode = 2;

          if (!stricmp(wip,"Charset=USA"))      vcharset = USA;
          if (!stricmp(wip,"Charset=France"))   vcharset = France;
          if (!stricmp(wip,"Charset=Germany"))  vcharset = Germany;
          if (!stricmp(wip,"Charset=UK"))       vcharset = UK;
          if (!stricmp(wip,"Charset=Denmark1")) vcharset = Denmark1;
          if (!stricmp(wip,"Charset=Sweden"))   vcharset = Sweden;
          if (!stricmp(wip,"Charset=Italy"))    vcharset = Italy;
          if (!stricmp(wip,"Charset=Spain"))    vcharset = Spain;
          if (!stricmp(wip,"Charset=Japan"))    vcharset = Japan;
          if (!stricmp(wip,"Charset=Norway"))   vcharset = Norway;
          if (!stricmp(wip,"Charset=Denmark2")) vcharset = Denmark2;

          if (!stricmp(wip,"Scanline=None"))    virtscanline = 0;
          if (!stricmp(wip,"Scanline=Half"))    virtscanline = 1;
          if (!stricmp(wip,"Scanline=Full"))    virtscanline = 2;
          if (!stricmp(wip,"DoubleView=Yes"))   virtdouble = 1;
          if (!stricmp(wip,"DoubleView=No"))    virtdouble = 0;

// memory
          if (!strnicmp(wip,"DefaultBIOS=",12)) strcpy(memrompath,&wip[12]);
          if (!stricmp(wip,"LanguageCard=Yes")) memnolc = 0;
          if (!stricmp(wip,"LanguageCard=No"))  memnolc = 1;
          if (!stricmp(wip,"ClearPattern=None"))        memorysetclearmode(0);
          if (!stricmp(wip,"ClearPattern=00"))          memorysetclearmode(1);
          if (!stricmp(wip,"ClearPattern=00FF"))        memorysetclearmode(2);
          if (!stricmp(wip,"ClearPattern=FF00"))        memorysetclearmode(3);
          if (!stricmp(wip,"ClearPattern=EA"))          memorysetclearmode(4);
          if (!stricmp(wip,"ClearPattern=0001"))        memorysetclearmode(5);
          if (!stricmp(wip,"ClearPattern=DEADBEEF"))    memorysetclearmode(6);
          if (!stricmp(wip,"ClearPattern=EFBEADDE"))    memorysetclearmode(7);
          if (!stricmp(wip,"IIC4080=40"))       memiic4080=IIC40;
          if (!stricmp(wip,"IIC4080=80"))       memiic4080=IIC80;

// printer
          if (!stricmp(wip,"Parallel=Activated"))       parallelactive = 1;
          if (!stricmp(wip,"Parallel=Deactivated"))     parallelactive = 0;

#ifdef EMUZ80
// z80
          if (!stricmp(wip,"Z80=Activated"))            z80active = 1;
          if (!stricmp(wip,"Z80=Deactivated"))          z80active = 0;
#endif

// mouse
          if (!stricmp(wip,"Mouse=Activated"))          mouseactive = 1;
          if (!stricmp(wip,"Mouse=Deactivated"))        mouseactive = 0;

// mass store
          if (!stricmp(wip,"MassStore=Activated"))      lldiskactive = 1;
          if (!stricmp(wip,"MassStore=Deactivated"))    lldiskactive = 0;

// drive
          if (!strnicmp(wip,"Disk1=",6))                strcpy(inidiskpath1,&wip[6]);
          if (!strnicmp(wip,"Disk2=",6))                strcpy(inidiskpath2,&wip[6]);
          if (!stricmp(wip,"DriveFastMode=Yes"))        drivefastflag = 1;
          if (!stricmp(wip,"DriveFastMode=No"))         drivefastflag = 0;
          if (!stricmp(wip,"DriveMessage=Yes"))         drivemessageflag = 1;
          if (!stricmp(wip,"DriveMessage=No"))          drivemessageflag = 0;

// cpu
          if (!stricmp(wip,"CPU=6502"))                 cpusettype(CPU_6502);
          if (!stricmp(wip,"CPU=65C02"))                cpusettype(CPU_65C02);
          if (!stricmp(wip,"CPU=65SC02"))               cpusettype(CPU_65SC02);
          if (!strnicmp(wip,"Delay=$",7))               sscanf(wip,"Delay=$%x",&inicpudelay);
          if (!stricmp(wip,"ShowRegs=Yes"))             cpuregsflag = 1;
          if (!stricmp(wip,"ShowRegs=No"))              cpuregsflag = 0;
          if (!stricmp(wip,"ShowMessage=Yes"))          cpumessageflag = 1;
          if (!stricmp(wip,"ShowMessage=No"))           cpumessageflag = 0;

// miscellaneous
          if (!strnicmp(wip,"StatePath=",10))           strcpy(inistatepath,&wip[10]);
          if (!stricmp(wip,"MenuLanguage=English"))     inimenulanguage = 'E';
          if (!stricmp(wip,"MenuLanguage=German"))      inimenulanguage = 'G';

/*
          if (!strnicmp(wip,"JoyCalibrateMinX=",17)) sscanf(wip,"JoyCalibrateMinX=%u",&GameMinX);
          if (!strnicmp(wip,"JoyCalibrateMinY=",17)) sscanf(wip,"JoyCalibrateMinY=%u",&GameMinY);
          if (!strnicmp(wip,"JoyCalibrateMaxX=",17)) sscanf(wip,"JoyCalibrateMaxX=%u",&GameMaxX);
          if (!strnicmp(wip,"JoyCalibrateMaxY=",17)) sscanf(wip,"JoyCalibrateMaxY=%u",&GameMaxY);
 */
        } // while
        fclose(file);

        if (vpal     != 0xff) { virtsetpalette   (vpal);     }
        if (vmono    != 0xff) { virtsetmonochrome(vmono);    }
        if (vtmode   != 0xff) { virtsettextmode  (vtmode);   }
        if (vlmode   != 0xff) { virtsetlresmode  (vlmode);   }
        if (vhmode   != 0xff) { virtsethresmode  (vhmode);   }
        if (vdhmode  != 0xff) { virtsetdhrsmode  (vdhmode);  }
        if (vcharset != None) { virtsetcharset   (vcharset); }

        if (cpuregswindow) {
          windowsetvisibility(cpuregswindow, cpuregsflag);
        }

        guipercent(window, 100,
"!\
EIni file read.;\
GIni-Datei gelesen.;\
");
//      windowpresskey(keyboard, window);
        channelclose(keyboard);
        channelclose(window);

        return NULL;    // no error

      } // readini


// --> ifndef DEF_INC_INI_C
#endif

