/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  Header file for Dapple shared components
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */


/*----------------------------------------


        lldisk.h


        see lldisk.c for implementation


----------------------------------------*/


#ifndef DEF_INC_LLDISK_H
#define DEF_INC_LLDISK_H


// **** include general libraries concerning definitions

//#ifndef DEF_ASMLIB
//#define DEF_ASMLIB            // set by dapple.h
//#endif

//#include <stdio.h>            // included by dapple.h
//#include <string.h>           // included by dapple.h
//#include "..\libs\general.h"  // included by dapple.h
//#include "..\libs\asmlib.h"   // included by dapple.h
#include "dapple.h"


// **** public functions

void            lldiskinit      (void);
void            lldisklight     (void);
void            lldiskloadrom   (unsigned int keyboard, unsigned int window);


unsigned char   *lldisknew      (slot *slotpointer, unsigned int slotnumber);
unsigned char   *lldiskstore    (void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   *lldiskrestore  (void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   lldiskread      (void *slotdata, unsigned int address);
void            lldiskwrite     (void *slotdata, unsigned int addr, unsigned char value);
unsigned char   lldiskromread   (void *slotdata, unsigned int addr);
void            lldiskromwrite  (void *slotdata, unsigned int addr, unsigned char value);
void            lldiskmenu      (void *slotdata);


// **** public global variables ****

extern  unsigned char   lldiskactive;


// --> #ifndef DEF_INC_LLDISK_H
#endif
