/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  Header file for Dapple shared components
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */


/*----------------------------------------


        memory.h


        see memory.c for implementation


----------------------------------------*/


#ifndef DEF_INC_MEMORY_H
#define DEF_INC_MEMORY_H


// **** include general libraries concerning definitions

//#ifndef DEF_ASMLIB
//#define DEF_ASMLIB            // set by dapple.h
//#endif

//#include <stdio.h>            // included by dapple.h
//#include <string.h>           // included by dapple.h
//#include "..\libs\general.h"  // included by dapple.h
//#include "..\libs\asmlib.h"   // included by dapple.h
#include "dapple.h"


// **** public type definition

typedef enum {IIC40, IIC80} IIC4080;


// **** public functions

void            soundinit       (void);
void            soundclick      (void);
void            soundmenu       (void);


void            memoryinit      (void);
void            memoryclose     (void);
unsigned char   *memoryrominit  (void);
unsigned int    memoryloadrom   (unsigned int keyboard, unsigned int window, unsigned char *newrompath);
unsigned int    memoryautoloadrom(unsigned int keyboard, unsigned int window);
void            memoryreset     (void);
void            memoryresetmenu (void);
void            memoryclear     (void);
void            memorysetclearmode(unsigned int value);
unsigned int    memorygetclearmode(void);
void            memoryclearresetmenu(void);
int             memorybloadfile (unsigned char *filename);
unsigned char   *memorystore    (unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   *memoryrestore  (unsigned int winprotocol, FILE *file, unsigned int percent);

unsigned char   memoryread      (unsigned int addr);
void            memorywrite     (unsigned int addr, unsigned int val);
void            memorymenu      (void);


// **** public global variables

extern  unsigned char   soundflag;

extern  unsigned char   memkey;
extern  unsigned int    memjoyx;
extern  unsigned int    memjoyy;
extern  unsigned char   memjoybutton0;
extern  unsigned char   memjoybutton1;
extern  IIC4080         memiic4080;
extern  unsigned char   memram[0x28000];
extern  unsigned char   memrompath[260];
extern  unsigned char   memnolc;
extern  unsigned char   memlcramr;
extern  unsigned char   memstore80;


// --> #ifndef DEF_INC_MEMORY_H
#endif
