@echo off
REM --------------------
REM     Make Emu][
REM --------------------
REM
REM Please put the program 'PRTWHEAD.EXE'
REM either into your source file folder or add a
REM path to it.
REM
echo Make Emu][ with assembly 6502 core ...
echo Build Emu][ by including all the main files into ONE single file.
echo Compiling may take a while ...



REM **** compile build file ****



echo Compiling build.c ...
REM redir -o build.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c build.c
redir -o build.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c build.c -D CPU_ASM

if errorlevel 1 goto e_build
goto f_build
:e_build
echo Error in build.c
goto end
:f_build



REM **** link files ****



echo Linking emu2.exe ...
redir -o link.err -eo gcc -s -o emu2.exe ..\libs\asmlib.o cpu6502asm.o build.o

if errorlevel 1 goto e_link
goto f_link
:e_link
ECHO Link error
goto end
:f_link



REM **** compress emu2.exe ****



upx --best emu2.exe



REM **** finish ****



echo emu2.exe done.



REM **** collect error files ****



:end
prtwhead *.err>error.txt
del *.err


:absend
