/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  MOUSE: mouse emulation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */


/*----------------------------------------


        mouse.c


        see include file mouse.h for definitions


----------------------------------------*/


#ifndef DEF_INC_MOUSE_C
#define DEF_INC_MOUSE_C


// **** include general definition files

//#include <stdio.h>            // included by mouse.h
//#include <string.h>           // included by mouse.h
#include <unistd.h>             // used for chdir()
//#include "..\libs\general.h"  // included by mouse.h
//#include "..\libs\asmlib.h"   // included by mouse.h
//#include "dapple.h"           // included by mouse.h


// **** include definition file of this source

#include "mouse.h"


// **** include further Emu][ specific files

#include "cpu65c02.h"
#include "gui.h"
#include "memory.h"
#include "video.h"


// **** constants

#define MODEON          1
#define MODEIRQMOVE     2
#define MODEIRQBUTTON   4
#define MODEIRQVBL      8
#define MODEIRQCXFALL   16
#define MODEIRQCXRAISE  32
#define MODEIRQCYFALL   64
#define MODEIRQCYRAISE  128

#define IRQBUTTON1PREV  1
#define IRQMOVE         2
#define IRQBUTTON       4
#define IRQVBL          8
#define IRQBUTTON1      16
#define IRQXYMOVE       32
#define IRQBUTTON0PREV  64
#define IRQBUTTON0      128
#define IRQCXFALL       16
#define IRQCXRAISE      32
#define IRQCYFALL       64
#define IRQCYRAISE      128


// **** variables

static unsigned char    mouserom[256];
static unsigned char    mousepresent;
unsigned char           mouseactive;
static unsigned int     mouseslot;
static unsigned char    mousemode;
static unsigned char    mousestate;
static unsigned char    mouseirq;
static int              mousex;
static int              mousey;
static int              mousereadx;
static int              mouseready;
static int              mouseoldx;
static int              mouseoldy;
static int              mouseleft;
static int              mousetop;
static int              mouseright;
static int              mousedown;
unsigned int            mousebutton;
static unsigned int     mouseoldbutton;






/*--------------------------------------*/


      void mouseinit(void) {

        memset(mouserom, 0xff, sizeof(mouserom));
        mousepresent    = 0;
        mouseactive     = 1;
        mouseslot       = 2;

      } // mouseinit


/*-------------------------------------*/


      void mouseloadrom(unsigned int keyboard, unsigned int window) {
        FILE *file;
        unsigned char filepath[260];
        unsigned char oldcwd[260];


        cwdxchgslash(oldcwd, 256);                              // read old directory path
        chdir(inirompath);                                      // set rom directory

        strcpy(filepath, "slotmous.a65");                       // search for source code
        file=fopen(filepath,"rb");
        if (!file) {
          strcpy(filepath, "slotmous.s");
          file=fopen(filepath,"rb");
          if (!file) {
            strcpy(filepath, "slotmous.asm");
            file=fopen(filepath,"rb");
          }
        }
        if (file) {
          fclose(file);                                         // close file again
          stringwritemessage(window,
"!\
EAssemble source code for mouse slot rom...\r;\
GAssembliere Source Code fr das Mouse-Slotrom...\r;\
;");
          screenupdate = 1;
          taskswitch();
          memset(mouserom, 0xff, sizeof(mouserom));
          assembler(mouserom, sizeof(mouserom), filepath);      // assemble source code
          mousepresent = 1;
        }
        else {
          strcpy(filepath, "mouse.rom");;                       // search binary rom file
          file=fopen(filepath,"rb");
          if (file) {
            stringwritemessage(window,
"!\
EReading mouse slot rom from file...\r;\
GLese Mouse-Slotrom aus Datei...\r;\
;");
            screenupdate = 1;
            taskswitch();
            fread(mouserom, sizeof(mouserom), 1, file);         // read binary rom file
            fclose(file);
            mousepresent = 1;
          }
          else {
            stringwritemessage(window,
"!\
ENo separate mouse slot rom found\r;\
GKein gesondertes Mouse-Slotrom vorhanden\r;\
;");
            screenupdate = 1;
            taskswitch();
            mousepresent = 0;
            mouseactive = 0;
          }
        }
        chdir(oldcwd);                  // restore original directory
//      windowpresskey(keyboard, window);
//      debugger(mouserom, sizeof(mouserom));

      } // mouseloadrom


/*--------------------------------------*/


      void mousevblank(void) {
        register unsigned int mouseirqold;

        if (mousemode & MODEON) {

          mouseirqold = mouseirq;

          mouseoldbutton = mousebutton;
          windowgetmouse(window, &mousex, &mousey, &mousebutton);

          if (mousex < 0) {
            mousex = 0;
          }
          else {
            if (mousex > 639) {
              mousex = 639;
            }
          }

          if (mousey < 0) {
            mousey = 0;
          }
          else {
            if (mousey > 383) {
              mousey = 383;
            }
          }
          mousex = mousex * (mouseright - mouseleft) / 640 + mouseleft;
          mousey = mousey * (mousedown - mousetop) / (400-16) + mousetop;

// check for falling/raising coor

          if (mousex < mousereadx) {
            if (mousemode & MODEIRQCXFALL) {
              mouseirq = mouseirq | IRQCXFALL;
            }
          }
          if (mousex > mousereadx) {
            if (mousemode & MODEIRQCXRAISE) {
              mouseirq = mouseirq | IRQCXRAISE;
            }
          }
          if (mousey < mouseready) {
            if (mousemode & MODEIRQCYFALL) {
              mouseirq = mouseirq | IRQCYFALL;
            }
          }
          if (mousey > mouseready) {
            if (mousemode & MODEIRQCYRAISE) {
              mouseirq = mouseirq | IRQCYRAISE;
            }
          }

          if ((mousex != mousereadx) || (mousey != mouseready)) {
            if (mousemode & MODEIRQMOVE) {
              mouseirq = mouseirq | IRQMOVE;
            }
            mousereadx = mousex;
            mouseready = mousey;
          }

          if (mousebutton && 0xff) {
            if (mousemode & MODEIRQBUTTON) {
              mouseirq = mouseirq | IRQBUTTON;
            }
          }

          if (mousemode & MODEIRQVBL) {
            mouseirq = mouseirq | IRQVBL;
          }

// check for interrupts

          if (mouseirqold != mouseirq) {
            cpusetstate(CPU_STATEIRQ1);
          }

        } // if (mousemode & MODEON)

      } // mousevblank


/*--------------------------------------*/


      void mousereset(void *slotdata) {

        mousemode       = 0;
        mousestate      = 0;
        mouseirq        = 0;
        mousex          = 0;
        mousey          = 0;
        mousereadx      = 0;
        mouseready      = 0;
        mouseoldx       = 0;
        mouseoldy       = 0;
        mouseleft       = 0;
        mousetop        = 0;
        mouseright      = 1023;//4095;
        mousedown       = 1023;//4095;
        mousebutton     = 0;
        mouseoldbutton  = 0;
        if (appletype == APPLEIIC) {
          mouseactive = 0;              // not on an Apple//c
        }

      } // mousereset


/*--------------------------------------*/


      unsigned char *mousestore(void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent) {
        unsigned char header[32];

        memset(header, 0x00, sizeof(header));
        strcpy(header, "MOUSE STATE V0.28");
        fwrite(header,          sizeof(header), 1, file);

        fwrite(mouserom,        sizeof(mouserom),       1, file);
        fwrite(&mousepresent,   sizeof(mousepresent),   1, file);
        fwrite(&mouseactive,    sizeof(mouseactive),    1, file);
        fwrite(&mouseslot,      sizeof(mouseslot),      1, file);
        fwrite(&mousemode,      sizeof(mousemode),      1, file);
        fwrite(&mousestate,     sizeof(mousestate),     1, file);
        fwrite(&mouseirq,       sizeof(mouseirq),       1, file);
        fwrite(&mousex,         sizeof(mousex),         1, file);
        fwrite(&mousey,         sizeof(mousey),         1, file);
        fwrite(&mousereadx,     sizeof(mousereadx),     1, file);
        fwrite(&mouseready,     sizeof(mouseready),     1, file);
        fwrite(&mouseoldx,      sizeof(mouseoldx),      1, file);
        fwrite(&mouseoldy,      sizeof(mouseoldy),      1, file);
        fwrite(&mouseleft,      sizeof(mouseleft),      1, file);
        fwrite(&mousetop,       sizeof(mousetop),       1, file);
        fwrite(&mouseright,     sizeof(mouseright),     1, file);
        fwrite(&mousedown,      sizeof(mousedown),      1, file);
        fwrite(&mousebutton,    sizeof(mousebutton),    1, file);
        fwrite(&mouseoldbutton, sizeof(mouseoldbutton), 1, file);

        guipercent(winprotocol, percent,
"!\
EMouse stored.;\
GMaus gespeichert;\
");
        return NULL;            // no error

      } // mousestore


/*--------------------------------------*/


      unsigned char *mouserestore(void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent) {
        unsigned char header[32];

        fread(header,           sizeof(header),         1,file);
        if (strcmp(header, "MOUSE STATE V0.28")) {
          stringwrite(winprotocol, "Mouse emulation data not found.\r");
          return taskseterror("Mouse emulation data not found.");
        }

        fread(mouserom,         sizeof(mouserom),       1, file);
        fread(&mousepresent,    sizeof(mousepresent),   1, file);
        fread(&mouseactive,     sizeof(mouseactive),    1, file);
        fread(&mouseslot,       sizeof(mouseslot),      1, file);
        fread(&mousemode,       sizeof(mousemode),      1, file);
        fread(&mousestate,      sizeof(mousestate),     1, file);
        fread(&mouseirq,        sizeof(mouseirq),       1, file);
        fread(&mousex,          sizeof(mousex),         1, file);
        fread(&mousey,          sizeof(mousey),         1, file);
        fread(&mousereadx,      sizeof(mousereadx),     1, file);
        fread(&mouseready,      sizeof(mouseready),     1, file);
        fread(&mouseoldx,       sizeof(mouseoldx),      1, file);
        fread(&mouseoldy,       sizeof(mouseoldy),      1, file);
        fread(&mouseleft,       sizeof(mouseleft),      1, file);
        fread(&mousetop,        sizeof(mousetop),       1, file);
        fread(&mouseright,      sizeof(mouseright),     1, file);
        fread(&mousedown,       sizeof(mousedown),      1, file);
        fread(&mousebutton,     sizeof(mousebutton),    1, file);
        fread(&mouseoldbutton,  sizeof(mouseoldbutton), 1, file);

        guipercent(winprotocol, percent,
"!\
EMouse restored.;\
GMaus geladen;\
");

        return NULL;            // no error

      } // mouserestore


/*--------------------------------------*/


      void mouseputcoor(void *slotdata) {

/*      memram[0x478+mouseslot] = (unsigned char)mousex;
        memram[0x578+mouseslot] = (unsigned char)(mousex >> 8);
        memram[0x4f8+mouseslot] = (unsigned char)mousey;
        memram[0x5f8+mouseslot] = (unsigned char)(mousey >> 8);
*/
        memorywrite(0x478+mouseslot,mousex);
        memorywrite(0x578+mouseslot,mousex >> 8);
        memorywrite(0x4f8+mouseslot,mousey);
        memorywrite(0x5f8+mouseslot,mousey >> 8);

      } // mouseputcoor


/*--------------------------------------*/


      unsigned char mouseread(void *slotdata, unsigned int addr) {

        return 0xff;

      } // mouseread


/*--------------------------------------*/


      void mousewrite(void *slotdata, unsigned int addr, unsigned char value) {
        register unsigned int t1;
        register unsigned int t2;
        register unsigned int t3;

        if ((inidebugflag) || (!mouseactive)) {
          return;
        }

        switch (addr & 0xf) {
          case 0x02 :
            mousemode = value & (MODEON | MODEIRQMOVE | MODEIRQBUTTON | MODEIRQVBL);
            memorywrite(0x7f8+mouseslot, mousemode);
            return;
          case 0x03 :
            switch (value) {
              case 0x00 :       // clampxmouse
                t1 = memoryread(0x478) | (memoryread(0x578) << 8);
                t2 = memoryread(0x4f8) | (memoryread(0x5f8) << 8);
                if (t1 > t2) {
                  t3 = t1;
                  t1 = t2;
                  t2 = t3;
                }
/*              if (t1 > 1023) {
                  t1 = 1023;
                }
                if (t2 > 1023) {
                  t2 = 1023;
                }
*/              mouseleft  = t1;
                mouseright = t2;
                return;
              case 0x01 :       /* clampymouse */
                t1 = memoryread(0x478) | (memoryread(0x578) << 8);
                t2 = memoryread(0x4f8) | (memoryread(0x5f8) << 8);
                if (t1 > t2) {
                  t3 = t1;
                  t1 = t2;
                  t2 = t3;
                }
/*              if (t1 > 1023) {
                  t1 = 1023;
                }
                if (t2 > 1023) {
                  t2 = 1023;
                }
*/              mousetop  = t1;
                mousedown = t2;
                return;
              case 0x02 :       // initmouse
                mousereset(slotdata);
                mouseputcoor(slotdata);
                memorywrite(0x778+mouseslot, mousestate);
                memorywrite(0x7f8+mouseslot, mousemode);
                return;
              case 0x03 :       // servemouse
                memorywrite(0x778+mouseslot, mousestate | (mouseirq & (IRQMOVE | IRQBUTTON | IRQVBL)));
                mouseirq = 0;   // reset mouse's interrupt line
                return;
              case 0x04 :       // readmouse
                mouseputcoor(slotdata);
                mousestate = ((mousestate >> 4) & IRQBUTTON1PREV) | ((mousestate >> 1) & IRQBUTTON0PREV);
                if ((mousex != mouseoldx) || (mousey != mouseoldy)) {
                  mousestate = mousestate | IRQXYMOVE;
                  mouseoldx = mousex;
                  mouseoldy = mousey;
                }
                mousestate = mousestate | ((mousebutton & 0xff)         ? IRQBUTTON0 : 0x00);
                mousestate = mousestate | ((mousebutton & 0xff0000)     ? IRQBUTTON1 : 0x00);
                memorywrite(0x778+mouseslot, mousestate  | (mouseirq & (IRQMOVE | IRQBUTTON | IRQVBL)));
                return;
             case 0x05 :        // setmouse
               return;
             case 0x06 :        // posmouse
                t1 = memoryread(0x478+mouseslot) | (memoryread(0x578+mouseslot) << 8);
                if (t1 < mouseleft) {
                  t1 = mouseleft;
                }
                else {
                  if (t1 > mouseright) {
                    t1 = mouseright;
                  }
                }
                mousex = t1;
                t1 = memoryread(0x4f8+mouseslot) | (memoryread(0x5f8+mouseslot) << 8);
                if (t1 < mousetop) {
                  t1 = mousetop;
                }
                else {
                  if (t1 > mousedown) {
                    t1 = mousedown;
                  }
                }
                mousey = t1;
                mouseputcoor(slotdata);
                return;
              case 0x07 :       // homemouse
                mousex = mouseleft;
                mousey = mousetop;
                mouseputcoor(slotdata);
                return;
              default :
                return;
            } // switch (value)
            return;
          default :
            return;
        } // switch
      } // mousewrite


/*--------------------------------------*/


      unsigned char mousereadiou(unsigned int addr) {
        return 0x00; /* not yet */

        switch (addr) {
          case 0xc058 :
            mousemode = mousemode & ~MODEIRQMOVE;
            break;
          case 0xc059 :
            mousemode = mousemode | MODEIRQMOVE;
            break;
          case 0xc05a :
            mousemode = mousemode & ~MODEIRQVBL;
            break;
          case 0xc05b :
            mousemode = mousemode | MODEIRQVBL;
            break;
          case 0xc05c :
            mousemode = (mousemode | MODEIRQCXFALL) & ~MODEIRQCXRAISE;
            break;
          case 0xc05d :
            mousemode = (mousemode | MODEIRQCXRAISE) & ~MODEIRQCXFALL;
            break;
          case 0xc05e :
            mousemode = (mousemode | MODEIRQCYFALL) & ~MODEIRQCYRAISE;
            break;
          case 0xc05f :
            mousemode = (mousemode | MODEIRQCYRAISE) & ~MODEIRQCYFALL;
            break;
        } /* switch (addr) */

        return virtvideobyte;

      } /* mousereadiou */


/*--------------------------------------*/


      void mousewriteiou(unsigned int addr) {
        return; /* not yet */

        switch (addr) {
          case 0xc058 :
            mousemode = mousemode & ~MODEIRQMOVE;
            break;
          case 0xc059 :
            mousemode = mousemode | MODEIRQMOVE;
            break;
          case 0xc05a :
            mousemode = mousemode & ~MODEIRQVBL;
            break;
          case 0xc05b :
            mousemode = mousemode | MODEIRQVBL;
            break;
          case 0xc05c :
            mousemode = (mousemode | MODEIRQCXFALL) & ~MODEIRQCXRAISE;
            break;
          case 0xc05d :
            mousemode = (mousemode | MODEIRQCXRAISE) & ~MODEIRQCXFALL;
            break;
          case 0xc05e :
            mousemode = (mousemode | MODEIRQCYFALL) & ~MODEIRQCYRAISE;
            break;
          case 0xc05f :
            mousemode = (mousemode | MODEIRQCYRAISE) & ~MODEIRQCYFALL;
            break;
        } // switch (addr)

        return;

      } // mousewriteiou


/*--------------------------------------*/


      unsigned char mouseromread(void *slotdata, unsigned int addr) {

        if (mouseactive) {
          return mouserom[addr & 0xff]; /* read from the rom which was separately loaded */
        }
        else {
          return 0xff;
        }

      } // mouseromread


/*--------------------------------------*/


      void mouseromwrite(void *slotdata, unsigned int addr, unsigned int value) {

        return;         // Nothing happens here

      } // mouseromwrite


/*--------------------------------------*/


      void mousemenu(void *slotdata) {
        unsigned int    menukeyboard;
        unsigned int    menuwindow;
        unsigned char   key;
        unsigned int    update;

        if (!windowaddio( -1, -1, WINDOWXSIZE, WINDOWYSIZE, -1, 1,
"!\
EMouse Options;\
GMaus Optionen;\
", 0, &menukeyboard, &menuwindow)) {
          update = 1;
          do {
            if (update) {
              channelout(menuwindow, 12);               // clear window
              stringwritemessage(menuwindow,
"!\
E\r[ESC] - Quit\r\r;\
G\r[ESC] - Verlasse Men\r\r;\
");
              if (appletype == APPLEIIC) {
                stringwritemessage(menuwindow,
"!\
E\rNo separate mouse slot present on an Apple//c;\
G\rKein separater Maus Slot vorhanden beim Apple//c;\
");
              }
              else {
                if (!mousepresent) {
                  stringwritemessage(menuwindow,
"!\
E\rNo mouse present;\
G\rKeine Maus vorhanden;\
");
                }
                else {
                  if (mouseactive) {
                    stringwritemessage(menuwindow,
"!\
E\r[A] - Mouse activated;\
G\r[A] - Maus aktiviert;\
");
                  }
                  else {
                    stringwritemessage(menuwindow,
"!\
E\r[A] - Mouse inactive;\
G\r[A] - Maus deaktiviert;\
");
                  }
                }
              }
              update = 0;
              screenupdate = 1;
            }
            do {
              taskswitch();
              if (windowgetclose(menuwindow)) {
                key = 27;
              }
              else {
                key = (unsigned char)channelin(menukeyboard);
              }
            }
            while ((key == 0) && (!exitprogram));
            switch (key) {
              case 'a' :
              case 'A' :
                if (mousepresent && (!(appletype == APPLEIIC))) {
                  if (mouseactive) {
                    mouseactive = 0;
                  }
                  else {
                    mouseactive = 1;
                  }
                  update = 1;
                }
                break;
            } // switch (key)
          }
          while ((key != 27) && (key != 32) && (key != 13) && (!exitprogram));
          channelclose(menukeyboard);
          channelclose(menuwindow);
        }

      } // mousemenu


/*--------------------------------------*/


      unsigned int mousenew(slot *slotpointer, unsigned int slotnumber) {

        mouseslot = slotnumber;

        slotpointer->slotclose          = (void *)&slotnofunction;
        slotpointer->slotreset          = (void *)&mousereset;
        slotpointer->slotstore          = (void *)&mousestore;
        slotpointer->slotrestore        = (void *)&mouserestore;
        slotpointer->slotget            = (void *)&mouseread;
        slotpointer->slotset            = (void *)&mousewrite;
        slotpointer->slotromget         = (void *)&mouseromread;
        slotpointer->slotromset         = (void *)&mouseromwrite;
        slotpointer->slotmenu           = (void *)&mousemenu;
        slotpointer->slotshift          = (void *)&slotnofunction;
        slotpointer->slotctrl           = (void *)&slotnofunction;
        slotpointer->slotshiftctrl      = (void *)&slotnofunction;
        slotpointer->slottype           = SLOTTYPEMOUSE;
        slotpointer->slotdata           = NULL;
        slotpointer->slotname           =
"!\
EMouse;\
GMaus;\
";
        if (!mousepresent) {
          return 1;             // no rom present ==> emulation not possible
        }
        return 0;

      } // mousenew


// --> #ifndef DEF_INC_MOUSE_C
#endif
