

#ifndef DEF_INC_ROM_C
#define DEF_INC_ROM_C


// **** include general definition files

#include <dos.h>		// used for sound(), delay(), nosound()
//#include <stdio.h>		// included by dapple.h
//#include <string.h>		// included by dapple.h
//#include <unistd.h>		// used for chdir()
//#include "..\libs\general.h"	// included by dapple.h
//#include "..\libs\asmlib.h"	// included by dapple.h
#include "dapple.h"


// **** include further Emu][ specific files

#include "version.h"
#include "cpu65c02.h"
#include "memory.h"

// cpu65c02.c
void hex8tostringf(unsigned int value, unsigned char *stringpointer);
void cpusetstate(unsigned int value);
void adc(unsigned int value);
void cmp(unsigned int value);
void cpx(unsigned int value);
void cpy(unsigned int value);


// **** definitions

#define	WNDLEFT	0x20
#define	WNDWDTH	0x21
#define	WNDTOP	0x22
#define	WNDBTM	0x23
#define	CH	0x24
#define CV	0x25
#define	GBASL	0x26
#define	GBASH	0x27
#define	BASL	0x28
#define	BASH	0x29






/*--------------------------------------*/


      void rompatch(unsigned char *filename) {

	assembler(&memram[0x20000], 0x8000, filename);

      } // rompatch


/*--------------------------------------*/


      void romcall(void) {

        cpupushstack(pc >> 8);
        cpupushstack(pc & 0xff);

      } // romreturn


      void romreturn(void) {

	pc	= ((cpupullstack() + (cpupullstack() << 8)) + 1) & 0xffff;

      } // romreturn

void romhgrset	(unsigned int value);
void romhgrclr	(void);
void romgbascalc(void);
void rombs	(void);
void romvtab	(void);
void romvtab2	(void);
void romhome	(void);
void romcr	(void);
void romlf	(void);
void romscroll	(void);
void romclreolz	(void);


/*--------------------------------------*/
/* $f3d8				*/
      void romhgr2(void) {
        areg = memoryread(0xc052);
        areg = memoryread(0xc055);
        romhgrset(0x40);
      } /* romhgr2 */
/*--------------------------------------*/
/* $f3e2				*/
      void romhgr(void) {
        areg = memoryread(0xc053);
        areg = memoryread(0xc054);
        romhgrset(0x20);
      } /* romhgr2 */
/*--------------------------------------*/
/* $f3ea				*/
      void romhgrset(unsigned int value) {
	memorywrite(0xe6, value);
	areg = memoryread(0xc050);
	areg = memoryread(0xc057);
	memorywrite(0x1c, 0);
	romhgrclr();
      } /* romhgr */
/*--------------------------------------*/
/* $f3f6				*/
      void romhgrclr(void) {
	register unsigned int addr;
	register unsigned int value;

	addr = memoryread(0xe6) << 8;
	value = memoryread(0x1c);
	dvalue8 = value;
	do {
	  memorywrite(addr, value);
	  areg = (value << 1) & 0xff;
	  cmp(0xc0);
	  if (nflag) {
	    value = value ^ 0x7f;
	  }
	  addr++;
	}
	while (addr & 0x1fff);
	memorywrite(0x1c, value);
	yreg = 0;
	memorywrite(0x1a, 0);
	areg = (addr >> 8);
	memorywrite(0x1b, areg);
	areg = areg & 0x1f;
      } /* romhgrclr */
/*--------------------------------------*/
/* $f411				*/
      void romhbascalc() {
	register unsigned int value;
	static const unsigned char bitmask[7] = {0x81, 0x82, 0x84, 0x88, 0x90, 0xa0, 0xc0};

	dvalue6++;
	memorywrite(0xe2, areg);
	memorywrite(0xe0, xreg);
	memorywrite(0xe1, yreg);
	memorywrite(GBASH, (((areg << 2) | ((areg >> 4) & 0x3)) & 0x1f) | memoryread(0xe6));
	memorywrite(GBASL, (((areg & 0xc0) | ((areg & 0xc0) >> 2)) >> 1) | ((areg & 0x8) << 4));
	value = xreg | (yreg << 8);
	yreg = value / 7;
	memorywrite(0xe5, yreg);
	xreg = (value % 7);
	memorywrite(0x30, bitmask[xreg]);
	xreg = xreg - 7;
	areg = memoryread(0xe4);
	memorywrite(0x1c, areg);
	cpuflagssetnz(areg);
	if (yreg & 1) {
	  areg = (areg << 1) & 0xff;
	  cmp(0xc0);
	  if (nflag) {
	    areg = memoryread(0x1c) ^ 0x7f;
	    memorywrite(0x1c, areg);
	    cpuflagssetnz(areg);
	  }
	}
	else {
	  cflag = 0;
	}
      } /* romhbascalc */
/*--------------------------------------*/
/* $f45a				*/
      void romhplot2() {
	register unsigned int addr;

	addr = ((memoryread(GBASL) | (memoryread(GBASH) << 8)) + yreg) & 0xffff;
	areg = ((memoryread(addr) ^ memoryread(0x1c)) & memoryread(0x30)) ^ memoryread(addr);
	memorywrite(addr, areg);
	cpuflagssetnz(areg);
      } /* romhplot2 */
/*--------------------------------------*/
/* $f800				*/
      void romplot() {
        memorywrite(0x2e, (areg & 1) ? 0xf0 : 0x0f);
        areg = areg >> 1;
        romgbascalc();
      } /* romplot */
/*--------------------------------------*/
/* $f80e				*/
      void romplot3() {
	register unsigned int addr;

	addr = ((memoryread(GBASL) | (memoryread(GBASH) << 8)) + yreg) & 0xffff;
	areg = ((memoryread(addr) ^ memoryread(0x30)) & memoryread(0x2e)) ^ memoryread(addr);
	memorywrite(addr, areg);
	cpuflagssetnz(areg);
      } /* romplot3 */
/*--------------------------------------*/
/* $f819				*/
      void romhline() {
	register unsigned int cmpvalue;

	romplot();
	romplot3();
	cmpvalue = memoryread(0x2c);
	cpy(cmpvalue);
	while (!cflag) {
	  yreg = (yreg + 1) & 0xff;
	  romplot3();
	  cpy(cmpvalue);
	}
      } /* romhline */
/*--------------------------------------*/
/* $f82a				*/
      void romvline() {
	register unsigned int cmpvalue;
	register unsigned int oldareg;

	cmpvalue = memoryread(0x2d);
	oldareg = areg;
	romplot();
	romplot3();
	areg = oldareg;
	cmp(cmpvalue);
	while (!cflag) {
	  areg = (areg + 1) & 0xff;
	  oldareg = areg;
	  romplot();
	  romplot3();
	  areg = oldareg;
	  cmp(cmpvalue);
	}
      } /* romvline */
/*--------------------------------------*/
/* $f838				*/
      void romclrtop2() {
	memorywrite(0x2d, yreg);
	yreg = 0x27;
	memorywrite(0x30, 0);
	do {
	  areg = 0;
	  romvline();
	  yreg = (yreg - 1) & 0xff;
	  cpuflagssetnz(yreg);
	}
	while (!nflag);
      } /* romclrtop2 */
/*--------------------------------------*/
/* $f847				*/
      void romgbascalc() {
	memorywrite(GBASH, (((areg >> 1) & 0x03) | 0x04));
	areg = (areg & 0x18) | ((areg & 1) ? 0x80 : 0x00);
	areg = (areg << 2) | areg;
	memorywrite(GBASL, areg);
	vflag = 0;
	cflag = 0;
	cpuflagssetnz(areg);
      } /* rombascalc */
/*--------------------------------------*/
      void rombascalc() {
	memorywrite(BASH, (((areg >> 1) & 0x03) | 0x04));
	areg = (areg & 0x18) | ((areg & 1) ? 0x80 : 0x00);
	areg = (areg << 2) | areg;
	memorywrite(BASL, areg);
	vflag = 0;
	cflag = 0;
	cpuflagssetnz(areg);
      } /* rombascalc */
/*--------------------------------------*/
/* $fb40				*/
      void romsetgr2() {
	memorywrite(WNDLEFT, 0);
	memorywrite(WNDWDTH, 0x28);
	memorywrite(WNDTOP,  areg);
	memorywrite(WNDBTM,  0x18);
	memorywrite(CV,      0x17);
	romvtab();
      } /* romsetgr2 */
/*--------------------------------------*/
/* $fb60				*/
#ifdef SHORT_BANNER
      void romwritetitle() {
	register unsigned int i;
	static const unsigned char title[9] = {"Dapple I"};

	romhome();
	for (i=0; i<8; i++) {
	  memorywrite(0x40e + i, title[i] | 0x80);
	}
      } /* romwritetitle */
#else
      void romwritetitle() {
	register unsigned int travel;

	/* Zan'nen desu.  Unfortunately, it's true that the BASIC
	   interpreter is owned by M$, and even after we replace the
	   entire monitor, we'll still be using the M$ BASIC code - but
	   not from an Apple ROM.  Instead, the code will be extracted
	   from the ROM code used by the shareware emulator "SimSystem
	   IIe".  No real problem as that can be freely downloaded and
	   the ROM code is "clean".  I may go so far as to bundle it
	   with release versions of the new emulator.  -uso. */

	static const unsigned char banner1[]={"EMU][ REE BIOS  Version "DappleVersion};
	static const unsigned char banner2[]={"Copyright (C) 2002-2003 EMU][ Project"};
	static const unsigned char banner3[]={"BASIC Copyright (C)1982 Microsoft Corp."};

	romhome();
	for (travel=0; banner1[travel]; travel++)
	  memorywrite (1024+256+travel,banner1[travel]|0x80);
	for (travel=0; banner2[travel]; travel++)
	  memorywrite (1024+384+travel,banner2[travel]|0x80);
	for (travel=0; banner3[travel]; travel++)
	  memorywrite (1024+512+travel,banner3[travel]|0x80);
      } /* romwritetitle */
#endif
/*--------------------------------------*/
/* $fb6f				*/
      void romsetpwrc() {
	areg = memoryread(0x3f3) ^ 0xa5;
	cpuflagssetnz(areg);
	memorywrite(0x3f4, areg);
      } /* romsetpwrc */
/*--------------------------------------*/
/* $fbf0				*/
      void romstoreadv() {
	yreg = memoryread(CH);
	memorywrite( ((memoryread(BASL) | (memoryread(BASH) << 8)) + yreg) & 0xffff, areg);
      } /* romstoreadv */
/*--------------------------------------*/
/* $fbf4				*/
      void romadvance() {
	areg = (memoryread(CH) + 1) & 0xff;
	memorywrite(CH, areg);
	cmp(memoryread(WNDWDTH));
	if (cflag) {
	  romcr();
	}
      } /* romadvance */
/*--------------------------------------*/
/* $fbfd				*/
      void romcout2() {

	if ((areg >= 0xa0) || (areg <= 0x7f)) {
	  romstoreadv();
	  romadvance();
	}
	else {
	  switch (areg) {
	    case 0x88 :
	      rombs();
	      break;
	    case 0x8a :
	      romlf();
	      break;
	    case 0x8d :
	      romcr();
	      break;
	  } /* switch (areg) */
	}
      } /* romcout2 */
/*--------------------------------------*/
/* $fc10				*/
      void rombs() {
	register unsigned int value;

	value = (memoryread(CH) - 1) & 0xff;
	if (value > 0x7f) {
	  memorywrite(CH, (memoryread(WNDWDTH) - 1) & 0xff);
	  areg  = memoryread(WNDTOP);
	  value = memoryread(CV);
	  cmp(value);
	  if (!cflag) {
	    memorywrite(CV, (value - 1) & 0xff);
	    romvtab2();
	  }
	}
	else {
	  memorywrite(CH, value);
	}
      } /* rombs */
/*--------------------------------------*/
/* $fc22				*/
      void romvtab() {
	areg = memoryread(CV);
	rombascalc();
	adc(memoryread(0x20));
	memorywrite(BASL, areg);
      } /* rombascalc */
/*--------------------------------------*/
/* $fc24				*/
      void romvtab2() {
	rombascalc();
	adc(memoryread(0x20));
	memorywrite(BASL, areg);
      } /* rombascalc */
/*--------------------------------------*/
/* $fc46				*/
      void romclreop2() {
	register unsigned int oldareg;
	register unsigned int cmpvalue;

	cmpvalue = memoryread(WNDBTM);
	do {
	  oldareg = areg;
	  romvtab2();
	  romclreolz();
	  yreg = 0;
	  areg = (oldareg + 1) & 0xff;
	  cmp(cmpvalue);
	}
	while (!cflag);
	areg = memoryread(CV);
	romvtab2();
      } /* romclreop2 */
/*--------------------------------------*/
/* $fc58				*/
      void romhome() {
	areg = memoryread(WNDTOP);
	memorywrite(CV, areg);
	yreg = 0;
	memorywrite(CH, 0);
	romclreop2();
      } /* romhome */
/*--------------------------------------*/
/* $fc60				*/
      void romcr() {
	memorywrite(CH, 0);
	romlf();
      } /* romcr */
/*--------------------------------------*/
/* $fc66				*/
      void romlf() {
        areg = (memoryread(CV) + 1) & 0xff;
        memorywrite(CV, areg);
        cmp(memoryread(WNDBTM));
        if (!cflag) {
          romvtab2();
        }
        else {
          memorywrite(CV, (areg - 1) & 0xff);
          romscroll();
        }
      } /* romlf */
/*--------------------------------------*/
/* $fc70				*/
      void romscroll() {
	register unsigned int oldareg;

	areg = memoryread(WNDTOP);
	oldareg = areg;
	romvtab2();
	do {
	  memorywrite(BASL+2, memoryread(BASL));
	  memorywrite(BASH+2, memoryread(BASH));
	  yreg = (memoryread(WNDWDTH) - 1) & 0xff;
	  areg = (oldareg + 1) & 0xff;
	  cmp(memoryread(WNDBTM));
	  if (!cflag) {
	    oldareg = areg;
	    romvtab2();
	    do {
	      memorywrite( ((memoryread(BASL+2) | (memoryread(BASH+2) << 8)) + yreg) & 0xffff,
			     memoryread(((memoryread(BASL)   | (memoryread(BASH)   << 8)) + yreg) & 0xffff));
	      yreg = (yreg - 1) & 0xff;
	    }
	    while (yreg < 0x80);
	    cflag = 0;
	  }
	}
	while (!cflag);
	yreg = 0;
	romclreolz();

      } /* romscroll */
/*--------------------------------------*/
      void romclreolz() {
	register unsigned int addr;
	register unsigned int cmpvalue;

	addr	 = memoryread(BASL) | (memoryread(BASH) << 8);
	cmpvalue = memoryread(WNDWDTH);
	areg	 = 0xa0;
	do {
	  memorywrite((addr + yreg) & 0xffff, 0xa0);
	  yreg = (yreg + 1) & 0xff;
	  cpy(cmpvalue);
	}
	while (!cflag);

      } // romclreolz
/*--------------------------------------*/


      void romexecute(unsigned int addr) {
        unsigned char message[80];

//	tasklogstring("COP addr = ");
//	taskloghex32(addr);
//	tasklogreturn();

	switch (addr) {

	  case 0xf3d8 :		/* HGR2 */
	    romhgr2();
	    romreturn();
	    break;
	  case 0xf3e2 :		/* HGR */
	    romhgr();
	    romreturn();
	    break;
	  case 0xf3ea :		/* HGRSET */
	    romhgrset(areg);
	    romreturn();
	    break;
	  case 0xf3f6 :		/* HGRCLR */
	    romhgrclr();
	    romreturn();
	    break;
	  case 0xf411 :		/* HBASCALC */
	    romhbascalc();
	    romreturn();
	    break;
	  case 0xf45a :
	    romhplot2();
	    romreturn();
	    break;
	  case 0xf800 :		/* PLOT */
	    romplot();			/* falls through */
	  case 0xf80e :
	    romplot3();
	    romreturn();
	    break;
	  case 0xf819 :		/* HLINE */
	    romhline();
	    romreturn();
	    break;
	  case 0xf828 :		/* VLINE */
	    romvline();
	    romreturn();
	    break;
	  case 0xf832 :		/* CLRSCR */
	    yreg = 0x2f;
	    romclrtop2();
	    romreturn();
	    break;
	  case 0xf836 :		/* CLRTOP */
	    yreg = 0x27;
	    romclrtop2();
	    romreturn();
	    break;
	  case 0xfb2f :		// INIT
		memorywrite(0x48, 0);
		areg = memoryread(0xc054);
		areg = memoryread(0xc056);	// falls through
	  case 0xfb39 :		// SETTXT
		areg = memoryread(0xc051);
		areg = 0;
		romsetgr2();
		romreturn();
		break;
	  case 0xfb40 :		// SETGR
		areg = memoryread(0xc050);
		areg = memoryread(0xc053);
		romclrtop2();
		yreg = 0x27;
		romclrtop2();
		areg = 0x14;
		romsetgr2();
		romreturn();
		break;
	  case 0xfb60 :		/* TITLE */
	    romwritetitle();
	    romreturn();
	    break;
	  case 0xfc42 :		/* CLREOP */
	    yreg = memoryread(CH);
	    areg = memoryread(CV);
	    romclreop2();
	    romreturn();
	    break;
	  case 0xfc58 :		/* HOME */
	    romhome();
	    romreturn();
	    break;
	  case 0xfb5b :		/* TABV	*/
	    memorywrite(CV, areg);
	    romvtab();
	    romreturn();
	    break;
	  case 0xfb6f :		/* SETPWRC */
	    romsetpwrc();
	    romreturn();
	    break;
	  case 0xfbc1 :		/* BASCALC */
	    rombascalc();
	    romreturn();
	    break;
	  case 0xfbdd :		/* BELL */
	    if (soundflag) sound(1000);	/*   1 KHz  */
	    delay (100);		/*  .1 sec  */
	    if (soundflag) nosound ();	/* Turn off */
	    romreturn();
	    break;
	  case 0xfbf0 :		/* STOREADV */
	    romstoreadv();		/* falls through */
	  case 0xfbf4 :		/* ADVANCE */
	    romadvance();
	    romreturn();
	    break;
	  case 0xfbfd :		/* COUT2 */
	    if (areg == 0x87) {
	      pc = 0xfbdd;
	    }
	    else {
	      romcout2();
	      romreturn();
	    }
	    break;
	  case 0xfc10 :		/* BS */
	    rombs();
	    romreturn();
	    break;
	  case 0xfc22 :		/* VTAB */
	    romvtab();
	    romreturn();
	    break;
	  case 0xfc60 :		/* CR */
	    romcr();
	    romreturn();
	    break;
	  case 0xfc66 :		/* LF */
	    romlf();
	    romreturn();
	    break;
	  case 0xfc70 :		/* SCROLL */
	    romscroll();
	    romreturn();
	    break;
	  case 0xfc9c :		/* CLREOL */
	    yreg = memoryread(0x24);	/* falls through */
	  case 0xfc9e :		/* CLREOLZ */
	    romclreolz();
	    romreturn();
	    break;
	  default :
	    cpusetstate(CPU_STATEGURU | CPU_STATEHALT);
	    imagefillbox(window, SLOTX1, 388, SLOTX1+1, 389, RGBLGHTOFF);

	    strcpy(message, "Illegal rom call at address $xxxx. Emulation halted.");
	    hex8tostringf(pc >> 8,   &message[29]);
	    hex8tostringf(pc & 0xff, &message[31]);
	    setmessage(message);
	    break;
	} // switch (addr)

      } // romexecute


// --> #ifndef DEF_INC_ROM_C
#endif
